<?php

namespace App\Console;

use App\Jobs\AutoResultDesawarMarket;
use App\Jobs\AutoResultMarket;
use App\Jobs\DeleteExpiredOtps;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */

    protected function schedule(Schedule $schedule): void
    {
        $schedule->command('cleanup:old-chats')->daily();
        $schedule->job(new DeleteExpiredOtps)->daily();
        // $schedule->job(new AutoResultMarket)->everyTwoMinutes();
        // $schedule->job(new AutoResultDesawarMarket)->everyTwoMinutes();
    }
    // php artisan schedule:run

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
